require( "scripts/style.lua" );
--DebugOut("ChoosePlayer");

GamersFont ={
  standardFont,
  24,
  BlackColor
};

function ShowSubmitOptions( show )
    EnableWindow( "delete", show )
    EnableWindow( "chooseok", show )
    EnableWindow( "editname", show )
end

function ShowCreateOptions( show )
    EnableWindow( "newplayer", show )
end

function UpdatePlayerChoices( curUser, numUsers, userTable )

    if (numUsers >= kMaxUsers) then
        ShowCreateOptions(false)
    else
        ShowCreateOptions(true)
    end

    if (numUsers==0) then
        ShowSubmitOptions( false )
    else
        ShowSubmitOptions( true )
    end

    for i = 0,numUsers-1 do
        SetLabel( "button"..i, userTable[ i+1 ] );
        EnableWindow( "button"..i, true ) ;
    end

    for i = numUsers, kMaxUsers do
        EnableWindow( "button"..i, false ) ;
    end

    if numUsers>0 then
        SetButtonToggleState( "button"..curUser, true );
    end

    DebugOut("UpdatePlayerChoices");
end

NameFont = {
  standardFont,
  24,
  BlackColor
};

HeaderFont = {
  bigButtonFont,
  50,
  DarkRedColor
};

ButtonX = kCenter;
ButtonY = 90;
ButtonYSpace = 30;

kMaxUsers = 10

NameButtonGraphics = {
    "buttons/choosenameover.png",
    "buttons/choosenamedown.png",
    "buttons/choosenameover.png",
    "buttons/choosenamedown.png"
};  

NameStyle= {
    type = kRadio,
    flags = kHAlignCenter + kVAlignCenter,
    font = StandardButtonFont,
    graphics = NameButtonGraphics,
    sound = kDefaultButtonSound
};

--gSelected = -1 ;

function AddButtons( N )

    t = { SetStyle(NameStyle), BeginGroup() };

    for i = 0,N-1 do
        table.insert(t,
            Button{
                name="button"..i,
--              command=function() gSelected = i; end,
                label="#name",
                x=ButtonX,
                y=ButtonY+(ButtonYSpace*i),
                font = GamersFont;
            }
        );  
    end

    return Group(t);
end

MakeDialog
{
    -- Name the modal dialog
    name="chooseplayer",
    Bitmap
    {
        name="grayimage",
        image="backgrounds/shadow.png",
        alpha=true,
        x=0,
        y=0
    };
    
    Bitmap
    { 
        image="backgrounds/select_player",
        x=kCenter,
        y=kCenter,
        w=675,
        h=574,
        
        ChoosePlayerWindow
        {
            x = 0, y = 0, w=kMax, h=kMax,
            
            Text
            {
                font = HeaderFont,
                name = "selectaplayer",
                x=0,y=5,w=kMax,h=kMax,
                flags = kHAlignCenter + kVAlignTop,
                label = "selectaplayer"
            };
            
            AddButtons( kMaxUsers );
            
            SetStyle(ButtonStyle);
                
            Button
            {
                --x=60,y=410,
                x=170, y=405,
                graphics = StButtonGraphicsMid,
                font = MenuButtonFont;
                scale=0.9,
                name="editname",
                label="",
                type = kPush,
                label="editname",
                command =
                    function()
                        gEnterNameValue = GetSelectedPlayerName();
                        name = DoModal("scripts/entername.lua");
                        if (not(name == nil)) then
                            local old_score = 0;
                            if (gGlobalPlayerInfo ~= nil) then
                                old_score = gGlobalPlayerInfo.gScore;
                            end
                            SetCurrentUser(GetCurrentSelectedUser());
                            ChangeCurrentUserName(name);
                            SetPlayerChoices();
                            SetWelcomeName();
                            if (old_score > 0) then
                                RelogPlayerScores(old_score);
                            end
                        end
                    end
            };

            Button
            {
                x=355, y=450,
                graphics = StButtonGraphicsMid,
                font = MenuButtonFont;
                scale=0.9,
                name="chooseok",
                label="ok",
                type = kPush,
                default = true,
                sound=kDefaultButtonSound,
                command = 
                    function()
                        SetCurrentUser(GetCurrentSelectedUser());
                        SetWelcomeName();
                        CPP_LoadGO();
                        PopModal("chooseplayer");
                    end
                
            };
                
            Button
            {
                x=355, y=405,
                graphics = StButtonGraphicsMid,
                font = MenuButtonFont;
                scale=0.9,
                name="newplayer",
                label="newplayer",
                type = kPush,
                command =
                    function()
                        gEnterNameValue = "";
                        name = DoModal("scripts/entername.lua");
                        if (not(name == nil)) then
                            CreateNewUser(name);
                            SetPlayerChoices()
                        end
                    end
            };
                
            Button
            {
                x=170, y=450,
                graphics = StButtonGraphicsMid,
                font = MenuButtonFont;
                scale=0.9,
                name="delete",
                label="deleteplayer",
                type = kPush,
                command =
                    function()
                        result = DisplayDialog { 
                            "scripts/yesno.lua", 
                            body ="deleteconfirm",
                            title = "deletetitle" 
                        };
                        if (result=='yes') then
                            DeleteUser(GetCurrentSelectedUser())
                            SetPlayerChoices()
                        end
                    end
                
            };
        }
    }
}


--UpdatePlayerChoices( 0,0, {} );

--SetPlayerChoices();

SetImageAlpha("grayimage",0.4);
